#!/bin/sh

DPLY_PAGE_DEPLOYING_RESULT_MSG=""
DPLY_PAGE_DEPLOYING_RESULT_OK=0
DPLY_PAGE_DEPLOYING_RESULT_ERROR=1

DPLY_PAGE_DEPLOYING_RESULT_CODE=${DPLY_PAGE_DEPLOYING_RESULT_ERROR}
DPLY_PAGE_DEPLOYING_RESULT_ROLLING=0

usr1_signal_handler() {

    # get percentage and trim blank (if any)
    RT_DEPLOYMENT_PERCENTAGE=`sed -n '1p' "${CONS_DEPLOYMENT_STATUS_FILE}" | awk '{print $1}'`    

    local counter=1
    local first_line=1 
    RT_DEPLOYMENT_PROGRESS_STATUS=""
    while read line
    do
        if [ "${first_line}" -eq 1 ]; then
            first_line=0
            continue
        fi
            
        if [ "${counter}" -eq 1 ]; then
            line="\\Z0${line}"
            counter=2
        else
            counter=1
        fi
        RT_DEPLOYMENT_PROGRESS_STATUS="${RT_DEPLOYMENT_PROGRESS_STATUS} \"${line}\""
    done < "${CONS_DEPLOYMENT_STATUS_FILE}"
}

dply_page_deploying_cleanup() {
    rm -f "${CONS_DEPLOYMENT_STATUS_FILE}"

    utility_close_esxi_service_sshd \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}"

    utility_accept_ctrl_c
}

dply_page_deploying() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    local deploy_step_file="first_deployment.step"
	local deploying_flag="/dev/shm/deploying.flag"
    trap 'usr1_signal_handler' SIGUSR1
    
    utility_reject_ctrl_c
	
    touch "${deploying_flag}"
    utility_open_esxi_service_sshd \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}"
    if [ "${?}" -ne 0 ]; then
        utility_accept_ctrl_c
		rm -f "${deploying_flag}"
        
        DPLY_PAGE_DEPLOYING_RESULT_CODE="${DPLY_PAGE_DEPLOYING_RESULT_ERROR}"
        DPLY_PAGE_DEPLOYING_RESULT_MSG="${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}"
        DPLY_PAGE_DEPLOYING_RESULT_ROLLING=-1
        return
    fi
    
    
    # launch deploy.sh
    local mainScript="${CONS_ECLI_DIR}deploy.sh"
    local ppid="${$}"
    local statusFile="${CONS_DEPLOYMENT_STATUS_FILE}"
    local stepFile="${CONS_ECLI_DIR}${deploy_step_file}"
    
    debug_print "start to 'Add/Remove sandboxes': script='${mainScript}', ppid='${ppid}', statusFile='${statusFile}', stepFile='${stepFile}'"
    ${mainScript} "${ppid}" "${statusFile}" "${stepFile}" 1>/dev/null 2>&1 &
    local retCode="${?}"
    if [ "${retCode}" -eq 1 ]; then
        local msg="LaunchMainScriptFail: mainScript='${mainScript}', retCode='${retCode}'"
        debug_print "${msg}"
        
        dply_page_deploying_cleanup
		rm -f "${deploying_flag}"

        DPLY_PAGE_DEPLOYING_RESULT_CODE="${DPLY_PAGE_DEPLOYING_RESULT_ERROR}"
        DPLY_PAGE_DEPLOYING_RESULT_MSG="${DPLY_PAGE_DEPLOYING_ERROR_LAUNCH_SCRIPT}"
        DPLY_PAGE_DEPLOYING_RESULT_ROLLING=-1
        return
    fi
        
    RT_DEPLOYMENT_PERCENTAGE=0
    RT_DEPLOYMENT_PROGRESS_STATUS="'' ''"
    while [ "${RT_DEPLOYMENT_PERCENTAGE}" -lt 100 ];
    do
    
        # error handling
        if [ "${RT_DEPLOYMENT_PERCENTAGE}" -eq -1 ]; then
            local errMsg="`cat ${CONS_DEPLOYMENT_STATUS_FILE} | egrep -i 'error|fail' | sed 's/exec error: //g'`"
            debug_print "DeploymentFail: ${errMsg}"
            
            dply_page_deploying_cleanup
			rm -f "${deploying_flag}"
                
            if [ "${errMsg}" == "The resource 'vmnic1' is in use." ]; then
                errMsg="${DPLY_PAGE_DEPLOYING_ERROR_NETWORK_ADAPTERS_OCCUPIED}"
            fi
            
            DPLY_PAGE_DEPLOYING_RESULT_CODE="${DPLY_PAGE_DEPLOYING_RESULT_ERROR}"
            DPLY_PAGE_DEPLOYING_RESULT_MSG="${errMsg}"
            DPLY_PAGE_DEPLOYING_RESULT_ROLLING=-1
            return
        fi
        
        # bring out tUI
        tp_mixedgauge \
            "${DPLY_PAGE_DEPLOYING_TITLE}" \
            "${DPLY_PAGE_DEPLOYING_TEXT}" \
            "${RT_DEPLOYMENT_PERCENTAGE}" \
            "${RT_DEPLOYMENT_PROGRESS_STATUS}"
            
        sleep 1
    done

    
    # after deployment is done...
    
    dply_page_deploying_cleanup

    RT_DEPLOY_STATUS=1    
    utility_save_deployed_conf "${RT_DEPLOY_STATUS}"
    if [ "${?}" -ne 0 ]; then
        debug_print "SaveConfFail: key='configuration.cli.deployed', value='${RT_DEPLOY_STATUS}'"
		rm -f "${deploying_flag}"
        
        DPLY_PAGE_DEPLOYING_RESULT_CODE="${DPLY_PAGE_DEPLOYING_RESULT_ERROR}"
        DPLY_PAGE_DEPLOYING_RESULT_MSG="${DPLY_PAGE_DEPLOYING_ERROR_DURING_DEPLOYING}"
        DPLY_PAGE_DEPLOYING_RESULT_ROLLING=-1
        return
    fi
    	
	
    DPLY_PAGE_DEPLOYING_RESULT_CODE="${DPLY_PAGE_DEPLOYING_RESULT_OK}"
    DPLY_PAGE_DEPLOYING_RESULT_MSG=""
    DPLY_PAGE_DEPLOYING_RESULT_ROLLING=1
}
